//=============================================================================
// AmmoShell.
//=============================================================================
class AmmoPistol extends DeusExAmmo;

#exec MESH IMPORT MESH=RepeaterAmmo ANIVFILE=MODELS\RepeaterAmmo_a.3d DATAFILE=MODELS\RepeaterAmmo_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=RepeaterAmmo X=0 Y=0 Z=100 PITCH=0 ROLL=0 YAW=0

#exec MESH SEQUENCE MESH=RepeaterAmmo SEQ=All              STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=RepeaterAmmo SEQ=RepeaterAmmo STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=RepeaterAmmo SEQ=Still STARTFRAME=0 NUMFRAMES=1

#exec MESHMAP NEW   MESHMAP=RepeaterAmmo MESH=RepeaterAmmo
#exec MESHMAP SCALE MESHMAP=RepeaterAmmo X=0.01933655625 Y=0.01933655625 Z=0.01933655625

#exec TEXTURE IMPORT FILE="Textures\CBAGray.pcx"	NAME="RepAGray"	GROUP="Icons" MIPS=Off
#exec TEXTURE IMPORT FILE="Textures\CBAGold.pcx"	NAME="RepAGold"	GROUP="Icons" MIPS=Off
#exec TEXTURE IMPORT FILE="Textures\CBADGold.pcx"	NAME="RepADGold"	GROUP="Icons" MIPS=Off

#exec MESHMAP SETTEXTURE MESHMAP=RepeaterAmmo NUM=0 TEXTURE=RepAGray
#exec MESHMAP SETTEXTURE MESHMAP=RepeaterAmmo NUM=1 TEXTURE=RepAGold
#exec MESHMAP SETTEXTURE MESHMAP=RepeaterAmmo NUM=2 TEXTURE=RepADGold

function bool UseAmmo(int AmountNeeded)
{
	local vector offset, tempvec, X, Y, Z;
	local ShellCasing shell;
	local DeusExWeapon W;

	if (Super.UseAmmo(AmountNeeded))
	{
		GetAxes(Pawn(Owner).ViewRotation, X, Y, Z);
		offset = Owner.CollisionRadius * X + 0.3 * Owner.CollisionRadius * Y;
		tempvec = 0.8 * Owner.CollisionHeight * Z;
		offset.Z += tempvec.Z;

		// use silent shells if the weapon has been silenced
		W = DeusExWeapon(Pawn(Owner).Weapon);
      if ((DeusExMPGame(Level.Game) != None) && (!DeusExMPGame(Level.Game).bSpawnEffects))
      {
         shell = None;
      }
      else
      {
         if ((W != None) && ((W.NoiseLevel < 0.1) || W.bHasSilencer))
            shell = spawn(class'ShellCasingSilent',,, Owner.Location + offset);
         else
            shell = spawn(class'ShellCasing',,, Owner.Location + offset);
      }

		if (shell != None)
		{
			shell.Velocity = (FRand()*20+90) * Y + (10-FRand()*20) * X;
			shell.Velocity.Z = 0;
		}
		return True;
	}

	return False;
}

function PostBeginPlay()
{
 SetTimer(1, True);
}

function Timer()
{
 if (Owner != None) if (Owner.IsA('Ninetoes')) AmmoAmount = 999;
}

defaultproperties
{
     bShowInfo=True
     AmmoAmount=12
     MaxAmmo=768
     ItemName="Repeater Pistol Slugs"
     ItemArticle="some"
     PickupViewMesh=LodMesh'RepeaterAmmo'
     Icon=Texture'DeusExUI.Icons.BeltIconAmmo10mm'
     largeIconWidth=0
     largeIconHeight=0
     Description=""
     beltDescription=""
     Mesh=LodMesh'RepeaterAmmo'
     CollisionRadius=2.800000
     CollisionHeight=1.000000
     DrawScale=0.450000
     PickupViewScale=0.450000
     bCollideActors=True
}
